export function setMacro(player, data) {
    player.setDynamicProperty('jigsawMacroData', JSON.stringify(data));
}
export function getMacro(player) {
    const data = player.getDynamicProperty('jigsawMacroData');
    if (typeof data != 'string') {
        return undefined;
    }
    return JSON.parse(data);
}
export function setMacroEnabled(player, value) {
    player.setDynamicProperty('jigsawMacroEnabled', value);
}
export function isMacroEnabled(player) {
    const enabled = player.getDynamicProperty('jigsawMacroEnabled');
    return typeof enabled == 'boolean' && enabled;
}
